<?php
/*
 +--------------------------------------------------------------------------+
 | Copyright IT Bliss LLC (c) 2012-2016                                     |
 +--------------------------------------------------------------------------+
 | This program is free software: you can redistribute it and/or modify     |
 | it under the terms of the GNU Affero General Public License as published |
 | by the Free Software Foundation, either version 3 of the License, or     |
 | (at your option) any later version.                                      |
 |                                                                          |
 | This program is distributed in the hope that it will be useful,          |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of           |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            |
 | GNU Affero General Public License for more details.                      |
 |                                                                          |
 | You should have received a copy of the GNU Affero General Public License |
 | along with this program.  If not, see <http://www.gnu.org/licenses/>.    |
 +--------------------------------------------------------------------------+
*/

class CRM_Utils_Ccfees {
    CONST CCFEES_PREFERENCES_NAME = 'CcFees Preferences';
  
    private static $_singleton = NULL;
  
    private $_settings;
  
    static function singleton() {
        if (!self::$_singleton) {
            self::$_singleton = new CRM_Utils_Ccfees();
        }
        return self::$_singleton;
    }
  
    /**
     * Construct a CcFees
     */
    public function __construct() {
        $this->_settings = $this->getSettings();
    }
  
    /**
     * Returns CcFees settings
     */
    static function getSettings() {
        return CRM_Core_BAO_Setting::getItem(CRM_Utils_Ccfees::CCFEES_PREFERENCES_NAME);
    }
  
    function setSetting($value, $name) {
        CRM_Core_BAO_Setting::setItem($value, CRM_Utils_Ccfees::CCFEES_PREFERENCES_NAME, $name);
    }
}
