<?php

require_once 'villages.civix.php';

use CRM_Villages_ExtensionUtil as E;

/**
 * Implements hook_civicrm_config().
 *
 * @link https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_config/
 */
function villages_civicrm_config(&$config): void {
  _villages_civix_civicrm_config($config);
}

/**
 * Implements hook_civicrm_install().
 *
 * @link https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_install
 */
function villages_civicrm_install(): void {
  _villages_civix_civicrm_install();
}

/**
 * Implements hook_civicrm_enable().
 *
 * @link https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_enable
 */
function villages_civicrm_enable(): void {
  _villages_civix_civicrm_enable();
}

/**
 * Implementation of hook_civicrm_rows
 */
function villages_civicrm_rows(&$rows) {
  //FIXME : generalise need to check w/ NG regarding this
  //{custom field id {228 : Activity fixed date}}

  $fieldID = 228;
  $customID = 'custom_' . $fieldID;
  foreach ($rows as $key => $row) {
    $result = civicrm_api3('Activity', 'get', [
      'sequential' => 1,
      'return' => [$customID],
      'id' => $row['DT_RowId'],
    ]);

    // assign value to scheduled date column for display
    if ($result['count']) {
      $scheduled_date = CRM_Utils_Array::value($customID, $result['values'][0]);
      $rows[$key]['scheduled_date'] = CRM_Utils_Date::customFormat($scheduled_date) ?? '';
    }
  }
}

function calculateSlotsAvailable($activityID) {
  $domain = getenv('DOMAIN');
  if ($domain == 'anv') {
    return;
  }
  //get Assignee, Activity Date
  //Activity location (custom field on activity “Location” (gid=52&id=247)
  //for this activity
  $result = civicrm_api3('Activity', 'get', array(
    'sequential' => 1,
    'return' => array('assignee_contact_id', 'custom_243', 'custom_247', 'activity_date_time'),
    'activity_id' => $activityID,
  ));

  $assigneeID = $result['values'][0]['assignee_contact_id'];
  $location = $result['values'][0]['custom_247'];
  $activityDate = $result['values'][0]['activity_date_time'];
  $requestedVolunteers= $result['values'][0]['custom_243'];

  $date = new DateTime($activityDate);
  $startDate = $date->format('Y-m-d');
  $end = CRM_Utils_Date::intervalAdd('day', 1, $startDate);
  $endDate = $end['Y'] .'-'.$end['M'] .'-'. $end['d'];

  //get the event with Event location (custom field on event 'Location' (gid=53&id=248))
  //Activity location (custom field on activity 'Location' (gid=52&id=247)
  //AND Event date (day, month, year) = activity date
  $result = civicrm_api3('Event', 'get', [
    'sequential' => 1,
    'return' => array('id'),
    'custom_248' => $location,
    'start_date' => ['BETWEEN' => [$startDate , $endDate]],
  ]);

  $eventID = $result['values'][0]['id'];
  $teamSize = 0;
  if ($eventID) {
    foreach ($assigneeID as $contactID) {
      $result = civicrm_api3('Participant', 'get', [
        'sequential' => 1,
        'return' => ['custom_241'],
        'event_id' => $eventID,
        'contact_id' => $contactID,
      ]);

      if ($result['count']) {
        $teamSize = $teamSize + $result['values'][0]['custom_241'];
      }
    }
  }

  $slotsAvailable = 0;
  $slotsAvailable = $requestedVolunteers - $teamSize;
  $params = array('entityID' => $activityID, 'custom_246' => $slotsAvailable);
  CRM_Core_BAO_CustomValueTable::setValues($params);
}

/**
 * Implementation of hook_civicrm_custom
 */
function villages_civicrm_custom( $op, $groupID, $entityID, $params) {
  //calculate the lat/long based on "Pickup Location" custom field
  if ($groupID == 11) {
    foreach($params as $param) {
      if ($param['column_name'] == 'pickup_location_49' && $param['value']) {
        $address = [];
        $address['country'] = $param['value'];
        CRM_Utils_Geocode_Google::format($address);

        $activity_params = array();
        $activity_params['entityID'] = $param['entity_id'];
        $lat = bcdiv($address['geo_code_1'], 1, 3) . rand(0,9);
        $long = bcdiv($address['geo_code_2'], 1, 3) . rand(0,9);

        //set lat/long (read only custom fields)
        $activity_params['custom_233'] = $lat; //lat
        $activity_params['custom_232'] = $long; //long
        CRM_Core_BAO_CustomValueTable::setValues($activity_params);
      }
    }
  }
}

/**
 * Function to get workflow activity types.
 */
function _get_workflow_activities() {
  // https://projects.cividesk.com/projects/7?modal=Task-3986-7
  // return workflow activities.
  $a =  CRM_Core_OptionGroup::values('activity_type', FALSE, FALSE, FALSE, 'AND v.filter = 0');
  return array_keys($a);
}

/**
 * Function to get taggable activity types.
 */
function _get_taggable_activities(){
  // https://projects.cividesk.com/projects/7?modal=Task-3986-7
  // return taggable activities.
  return array (
    89,    // Volunteer Opportunity
    99,    // Volunteer Care Call
    104,   // Volunteer Outdoor/Indoor Work
    105,   // Volunteer Errands/Appointments
    106,   // Volunteer Pet Help
    67,    // Warm Welcome Calls New Members and Volunteers
    58,    //Snow Shoveling
    86,    //Ongoing relationship tracking
    111,   //Event tracking
    113,   //Service Saturdays
  );
}

/**
 * Implementation of hook_civicrm_post
 */
function villages_civicrm_post($op, $objectName, $objectId, &$objectRef) {

  global $assigneeID, $assignee_date, $activity_status_id;

  if ($op != 'delete' && $objectName == 'Address' && $objectRef->contact_id && $objectRef->is_primary && $objectRef->postal_code) {
    $value = $tagMap= array();
    $group = array('id' => 265);
    CRM_Core_OptionValue::getValues($group, $value);
    foreach($value as $val) {
      if ($objectRef->postal_code == $val['label']) {
        $tag = $val['value'];
      }
    }
  }
  if ($op == 'create' && $objectName == 'Activity' && $objectRef->activity_type_id == 116) {
    $params = array('entityID' => $objectId, 'custom_109' => 7);
    CRM_Core_BAO_CustomValueTable::setValues($params);
  }
  //no custom data found for Service Saturday in ANV
  if ($op != 'delete' && $objectName == 'Activity' && $objectRef->activity_type_id == 113) {
    //https://projects.cividesk.com/projects/7?modal=Task-4616-7
    //{Service Saturdays : 113}
    calculateSlotsAvailable($objectId);
  }
  //https://projects.cividesk.com/projects/7/tasks/4410
  //{Volunteer Opportunity : 89}
  $workflow_activities = _get_workflow_activities();

  if ($op != 'delete' && $objectName == 'Activity' && in_array($objectRef->activity_type_id, $workflow_activities)) {
    if ($op == 'create') {
      //date requested {custom field id : 229} should be same as Activity Date
      //when new activity is created
      $params = array('entityID' => $objectId, 'custom_229' => $objectRef->activity_date_time);
      CRM_Core_BAO_CustomValueTable::setValues($params);
    }
  }

  $workflow_activities = _get_workflow_activities();
  if ($op == 'create' && $objectName == 'ActivityContact' && $objectRef->record_type_id == 1) {
    $type = CRM_Core_DAO::getFieldValue('CRM_Activity_DAO_Activity', $objectRef->activity_id, 'activity_type_id');
    if ($type == 113) {
      calculateSlotsAvailable($objectRef->activity_id);
    }

    if ($assigneeID != $objectRef->contact_id) {
      if (in_array($type, $workflow_activities)) {
        //we need to set assigned date to now
        //if the assignee is new or activity has been re-assigned
        $params = array('entityID' => $objectRef->activity_id, 'custom_230' => date('YmdHis'));
        CRM_Core_BAO_CustomValueTable::setValues($params);

        //set activity status to 'Assigned'
        //new status will be used only for volunteer opportunities and warm welcome activities
        //update the status if the activity type is 'Scheduled' OR 'To Be Scheduled'
        $query = "UPDATE `civicrm_activity` SET `status_id` = '12'
          WHERE `civicrm_activity`.`id` = %1 AND
          activity_type_id IN (89, 105, 116) AND
          `status_id` IN (1, 10)
          ;";
        $queryParams = [1 => [$objectRef->activity_id, 'Positive']];
        $dao = CRM_Core_DAO::executeQuery($query , $queryParams);
      }
    }
    else {
      if (in_array($type, $workflow_activities)) {
        //preserve $assignee_date if no change in assignee contact
        $params = [
          'entityID' => $objectRef->activity_id,
          'custom_230' => CRM_Utils_Date::isoToMysql($assignee_date),
        ];
        CRM_Core_BAO_CustomValueTable::setValues($params);

        //preserve activity status if no change in assignee contact
        $query = "UPDATE `civicrm_activity` SET `status_id` = %2 WHERE `civicrm_activity`.`id` = %1 AND activity_type_id IN (89,105, 116);";
        $queryParams = [
          1 => [$objectRef->activity_id, 'Positive'],
          2 => [$activity_status_id, 'Positive']
        ];

        $dao = CRM_Core_DAO::executeQuery($query , $queryParams);
      }
    }
  } elseif ($op == 'delete' && $objectName == 'ActivityContact' && $objectRef->record_type_id == 1) {
    $type = CRM_Core_DAO::getFieldValue('CRM_Activity_DAO_Activity', $objectRef->activity_id, 'activity_type_id');
    $workflow_activities = _get_workflow_activities();
    if (in_array($type, $workflow_activities)) {
      $assigneeID = $objectRef->contact_id;
      $result = civicrm_api3('Activity', 'get', [
      'sequential' => 1,
      'id' => $objectRef->activity_id,
      'return' => ['custom_230', 'status_id'],
     ]);
      $assignee_date = $result['values'][0]['custom_230'];
      $activity_status_id = $result['values'][0]['status_id'];

      //set activity status to 'Scheduled'
      $query = "UPDATE `civicrm_activity` SET `status_id` = '1' WHERE `civicrm_activity`.`id` = %1 AND activity_type_id IN (89, 105, 116);";
      $queryParams = [1 => [$objectRef->activity_id, 'Positive']];
      $dao = CRM_Core_DAO::executeQuery($query , $queryParams);

      //date assigned {custom field id : 230} should be unset when
      //the assignee has been removed
      $params = array('entityID' => $objectRef->activity_id, 'custom_230' => '');
      CRM_Core_BAO_CustomValueTable::setValues($params);
    }


  }

  // https://projects.cividesk.com/projects/7?modal=Task-3986-7
  // https://projects.cividesk.com/projects/7/tasks/5307
  // https://projects.cividesk.com/projects/7/tasks/5526
  // Add custom data record with the activity's target contact to the activity
  // for activities of the following types.
  // {58 : Snow Shoveling}
  // {67 : Warm Welcome Calls New Members and Volunteers}
  // {89 : Volunteer Opportunity}
  // {113 :Service Saturdays}
  // {115 : Ditch the desk}
  // {116 : Warm Welcome}
  $act_types = [58, 67, 89, 113, 115, 116];
  if ($op != 'delete' && $objectName == 'Activity' && in_array($objectRef->activity_type_id, $act_types)) {
    $targetContactID = $phone = $address = '';
    $customParams['entityID'] = $objectId; // Activity ID
    $customParams['entityType'] = 'Activity';
    $customfieldValues = CRM_Core_BAO_CustomValueTable::getValues($customParams);
    // if pick location OR phone details absent then fetch target contact details
    if (empty($customfieldValues['custom_49']) || empty($customfieldValues['custom_50'])) {
      $resultTargetContact = civicrm_api3('ActivityContact', 'get', array(
        'sequential' => 1,
        'return' => array('contact_id'),
        'activity_id' => $objectId,
        'record_type_id' => 'Activity Targets',
      ));
      if (!empty($resultTargetContact['values'])) {
        // fetch first contact if multiple contact present
        $activityContact = reset($resultTargetContact['values']);
        $targetContactID = $activityContact['contact_id'];
      }
      if (empty($targetContactID)) {
        return; // No target contact found
      }
      // Get the primary phone number
      $resultPhoneNumber = civicrm_api3('Phone', 'get', array(
        'sequential' => 1,
        'return' => array('phone'),
        'contact_id' => $targetContactID,
        'is_primary' => 1,
      ));

      if (!empty($resultPhoneNumber['values'])) {
        $contactPhone = reset($resultPhoneNumber['values']);
        $phone = $contactPhone['phone'];
      }
      // Get Primary Details with formated display
      $entityBlock = array('contact_id' => $targetContactID);
      $addressArray = CRM_Core_BAO_Address::getValues($entityBlock);
      if ( ! empty( $addressArray) ) {
        // Home Address, may be its primary
        $addressPrimary = array_filter($addressArray,
          function ($data) {
            // filter data using is_primary flag
            if ($data['location_type'] == 'Home') {
              return $data;
            } else {
              return '';
            }
          }
        );
        // if home address is not present then try primary address
        if (empty($addressPrimary)) {
          $addressPrimary = array_filter($addressArray,
            function ($data) {
              // filter data using is_primary flag
              if ($data['is_primary']) {
                return $data;
              } else {
                return '';
              }
            }
          );
        }
        // if address presnet then format display_text
        if (!empty($addressPrimary)) {
          $addressPrimary = reset($addressPrimary);
          $address = str_replace(array("\r\n","\r","\n"),', ',trim($addressPrimary['display_text']));
        }
      }
    }

    // Pick up location
    if (empty($customfieldValues['custom_49']) && !empty($address)) {
      $set_params = array('entityID' => $objectId, 'custom_49' => $address);
      CRM_Core_BAO_CustomValueTable::setValues($set_params);
    }
    // Member Phone Number
    if (empty($customfieldValues['custom_50']) && !empty($phone)) {
      $set_params = array('entityID' => $objectId, 'custom_50' => $phone);
      CRM_Core_BAO_CustomValueTable::setValues($set_params);
    }

  }
}

/**
 * Implementation of hook_civicrm_pre
 */
function villages_civicrm_pre($op, $objectName, $objectId, &$objectRef ) {
  if ($op == 'create' && $objectName == 'Activity' && in_array($objectRef['activity_type_id'], [116])) {
    $objectRef['duration'] = 120;
    $objectRef['location'] = "Member's Home";
  }
  //https://projects.cividesk.com/projects/7/tasks/4410
  //https://projects.cividesk.com/projects/7?modal=Task-5313-7
  $workflow_activities = _get_workflow_activities();
  if ($op != 'delete' && $objectName == 'Activity' && in_array($objectRef['activity_type_id'], $workflow_activities)) {
    if ($op == 'edit') {
      $oldStatus = CRM_Core_DAO::getFieldValue('CRM_Activity_DAO_Activity', $objectId, 'status_id');

      //Date the activity status is changed to completed (id=2),
      //but also unable to find volunteer (id=9), no-show (id=8), unreachable (id=5)
      $statusIDs = [2, 3, 9, 8, 5];
      if ($oldStatus != $objectRef['status_id']) {
	      if (in_array($objectRef['status_id'], $statusIDs)) {
          //date completed {custom field id : 231} should be same as Activity Date
          //when activity status is changed to 'Completed'
          $params = array('entityID' => $objectId, 'custom_231' => date('YmdHis'));
          CRM_Core_BAO_CustomValueTable::setValues($params);
	      }
	      if (in_array($oldStatus, $statusIDs)) {
          //date completed should be unset
          //when activity status is changed from 'Completed' to any other
          $params = array('entityID' => $objectId, 'custom_231' => '');
          CRM_Core_BAO_CustomValueTable::setValues($params);
	      }
      }
    }
  }

  // https://projects.cividesk.com/projects/7?modal=Task-3986-7
  // Add custom data record with the activity's target contact to the activity
  // for activities of the following types.
  // Get taggable activities.
  $taggable_types = _get_taggable_activities();
  if ($op == 'create' && $objectName == 'Activity' && in_array($objectRef['activity_type_id'], $taggable_types)) {
    // check target contact exist
    if (!empty($objectRef['target_contact_id'])) {
      $target_contact_id = reset($objectRef['target_contact_id']);
    }
    // get target contact tags
    $tagList = CRM_Core_BAO_EntityTag::getTag($target_contact_id);
    if (!empty($tagList)) {
      // get list of tag extends for contact and activity.
      $query = "SELECT id FROM `civicrm_tag` WHERE used_for LIKE '%civicrm_contact%' AND used_for LIKE '%civicrm_activity%' ";
      $dao = CRM_Core_DAO::executeQuery( $query );
      $commonTag = array(); // list of tag can we extend for both contact and activity
      while ( $dao->fetch( ) ) {
        $commonTag[$dao->id] = $dao->id;
      }
      // get tag id only eligible for activity
      $activityTag = array_intersect($tagList, $commonTag);
      // if such tag available then assign it to activity
      if (!empty($activityTag)) {
        $currentTag = array();
        // Check is any tag assigned during activity create, if present then merge current activity tag with contact tag
        if (!empty($objectRef['tag'])) {
          $currentTag = explode(',', $objectRef['tag']);
        }
        // array_values used for remove duplicate value
        $objectRef['tag'] = implode(',', array_values(array_merge($currentTag, $activityTag)));
      }
    }
  }
}

/**
 * Implementation of hook_civicrm_buildForm
 */
function villages_civicrm_buildForm($formName, &$form) {
  //not sure whether this is needed for Villages
  //need to check with Virginie
  if ($formName == 'CRM_Activity_Form_Activity' && $form->_action == 1) {
      //https://projects.cividesk.com/projects/7?modal=Task-6051-7
      $welcome = 0;
      //check if activity type is 'Warm Welcome'
      if (in_array($form->_activityTypeId, [116])) {
        $welcome = 1;
      }

      //warm welcom disabled in ANV -
      //need to discuss w/ Virginie
      //prefill fields
      CRM_Core_Region::instance('page-body')->add(array(
        'script' => "
         fillFields();
         cj('#activity_type_id').change( function() {
          fillFields();
         });
         function fillFields() {
           current_val = cj('#activity_type_id').val();
           // Warm welcome act type
           if ($welcome || current_val ==  116) {
             setTimeout(function waitWF() {
               if (cj('.custom-group-Volunteer_Portal').length > 0) {
                cj('#subject').val('Warm Welcome Visit');
                cj('#duration').val(120);
                cj('#location').val('Member\'s Home');
                cj('#status_id').select2('val', 10);
                cj('#custom_109_-1').select2('val', 7);
               } else {
                 setTimeout(waitWF, 250);
               }
             }, 250);
           }
        }
        ",
      ));

    //{Volunteer Opportunity : 89}
    //{Event tracking : 111}
    //{Snow Shoveling : 58}
    $activityTypeID = [89, 105, 116];
    $vol = $date = 0;
    if (in_array($form->_activityTypeId, $activityTypeID)) {
      //remove date on view screen
      if ($form->_action == 4) {
        CRM_Core_Region::instance('page-body')->add(array(
          'script' => "
            cj('.crm-activity-form-block-activity_date_time').hide();
          ",
        ));
      }
      $date = 1;
    }

    $workflow_activities = _get_workflow_activities();
    //check if activity type is 'Volunteer Opportunity'
    if (in_array($form->_activityTypeId, $workflow_activities )) {
      $vol = 1;
    }

    // Move custom fields next to amount
    CRM_Core_Region::instance('page-body')->add(array(
      'script' => "
       moveFields();
       cj('#activity_type_id').change( function() {
        moveFields();
       });
       function moveFields() {
         current_val = cj('#activity_type_id').val();
         // Vol act type
         if ($vol || cj.inArray(current_val, $workflow_activities )) {
           // Wait till custom field is dynamically created on page
           // move the reference additional information next to subject
           setTimeout(function waitAct() {
             if (cj('.custom-group-Volunteer_Portal').length > 0) {
               if ($date || cj.inArray(current_val, $activityTypeID )) {
                 cj('.crm-activity-form-block-activity_date_time').hide();
               } else {
                 cj('.crm-activity-form-block-activity_date_time').show();
               }

               cj( \"<tr class='replaced_wf_div'><td colspan='2' id='replaced_wf_td'><table><tbody></tbody></table> </td></tr>\" ).insertAfter('.crm-activity-form-block-status_id');
               cj('.custom-group-Workflow_dates').detach().appendTo('#replaced_wf_td');
               cj('.custom-group-Workflow_dates').removeClass('collapsed');

               cj( \"<tr class='replaced_vp_div'><td colspan='2' id='replaced_vp_td'><table><tbody></tbody></table> </td></tr>\" ).insertAfter('.crm-activity-form-block-status_id');
               cj('.custom-group-Volunteer_Portal').detach().appendTo('#replaced_vp_td');
               cj('.custom-group-Volunteer_Portal').removeClass('collapsed');
             } else {
               setTimeout(waitAct, 250);
             }
           }, 250);

           setTimeout(function waitWF() {
            if (cj('[id^=Workflow_dates]').length > 0) {
              cj( \"<tr class='replaced_wf_div'><td colspan='2' id='replaced_wf_td'><table><tbody></tbody></table> </td></tr>\" ).insertAfter('.crm-activity-form-block-status_id');
              cj('[id^=Workflow_dates]').detach().appendTo('#replaced_wf_td tbody');
              cj('[id^=Workflow_dates]').removeClass('collapsed');
            } else {
              setTimeout(waitWF, 250);
            }
          }, 250);

           setTimeout(function waitVP() {
             if (cj('[id^=Volunteer_Portal]').length > 0) {
               cj( \"<tr class='replaced_vp_div'><td colspan='2' id='replaced_vp_td'><table><tbody></tbody></table> </td></tr>\" ).insertAfter('.crm-activity-form-block-status_id');
               cj('[id^=Volunteer_Portal').detach().appendTo('#replaced_vp_td tbody');
               cj('[id^=Volunteer_Portal]').removeClass('collapsed');
             } else {
               setTimeout(waitVP, 250);
             }
           }, 250);
         }  else {
           cj('.crm-activity-form-block-activity_date_time').show();
           // Hide the custom data
           cj('.replaced_wf_div').remove();
         }
      }
      ",
    ));
  }
}

/**
 * Implementation of hook_civicrm_alterMailParams()
 *
 */
function villages_civicrm_alterMailParams(&$params, $context = NULL) {
  //https://projects.cividesk.com/projects/7/tasks/4957
  if (!empty($params['groupName']) && $params['groupName'] == 'Email from API' && $params['messageTemplateID'] == 274) {
    $value = $params['extra_data']['event']['custom_248'];
    $params['tplParams']['custom_248'] = $params['extra_data']['event']['custom_248'];
    $params['tplParams']['start_date'] = CRM_Utils_Date::customFormat($params['extra_data']['event']['start_date'], '%Y-%m-%d');
    foreach ($params['tplParams'] as $key => $value) {
      $token = '{#event.' . $key.'}';
      foreach ([
        'html',
        'text',
        'subject',
      ] as $prop) {
        $params[$prop] = preg_replace("/([^\{])?$token/", "\${1}$value", $params[$prop]);
      }
    }
  }

  //https://projects.cividesk.com/projects/7?modal=Task-6232-7
  if (!empty($params['groupName']) && $params['groupName'] == 'Email from API' && $params['messageTemplateID'] == 307) {
    $activityId = $params['extra_data']['activity']['activity_id'];
    if ($activityId) {
      $result = civicrm_api3('Activity', 'get', [
        'sequential' => 1,
        'id' => $activityId,
      ]);
      $params['tplParams']['custom_227'] = '';
      $params['tplParams']['custom_228'] = '';
      $params['tplParams']['details'] = $params['tplParams']['details'] ?? '';
      //assign all activity related fields to the template
      //custom and core
      foreach ($result['values'][0] as $key => $val) {
        if (substr($key, 0, 7) == 'custom_') {
          $params['tplParams'][$key] = CRM_Core_BAO_CustomField::displayValue($val, $key);
        }
        else {
          $params['tplParams'][$key] = $val;
        }
      }

      foreach ($params['tplParams'] as $key => $value) {
        $token = '{#activity.' . $key.'}';
        foreach ([
          'html',
          'text',
          'subject',
        ] as $prop) {
          $params[$prop] = preg_replace("/([^\{])?$token/", "\${1}$value", $params[$prop]);
        }
      }
    }
  }

  if (!empty($params['valueName']) && $params['valueName'] == 'case_activity') {
    unset($params['tplParams']['activity']['fields'][3]);
    unset($params['tplParams']['activity']['fields'][4]);
    unset($params['tplParams']['activity']['fields'][7]);
    unset($params['tplParams']['activity']['customGroups']['Workflow dates']);
  }

  //https://projects.cividesk.com/projects/7/tasks/4658
  if (in_array(CRM_Utils_Array::value('messageTemplateID', $params), [156, 173, 204, 257])) {
    $activityId = CRM_Utils_Array::value('activity_id', $params);
    if ($activityId) {
      $result = civicrm_api3('Activity', 'get', [
        'sequential' => 1,
        'id' => $activityId,
      ]);

      //assign all activity related fields to the template
      //custom and core
      foreach ($result['values'][0] as $key => $val) {
        if (substr($key, 0, 7) == 'custom_') {
          $params['tplParams'][$key] = CRM_Core_BAO_CustomField::displayValue($val, $key);
        }
        else {
          $params['tplParams'][$key] = $val;
        }
      }


      //assign target sort name to the template for the activity
      $result = civicrm_api3('Activity', 'get', [
        'sequential' => 1,
        'return' => ['target_contact_id'],
        'id' => $activityId,
      ]);
      $params['tplParams']['target_contact_name'] = current($result['values'][0]['target_contact_name']);
    }
  }
  if (!empty($params['valueName']) && $params['valueName'] == 'case_activity' && $params['tplParams']['activityTypeName'] == 'Event Tracking') {
    //https://projects.cividesk.com/projects/7/tasks/4491
    $params['messageTemplateID'] = 149;
    $domain = getenv('DOMAIN');
    if ($domain == 'alh') {
     $params['from'] = 'Tanya Matthias <tanya@alittlehelp.org>';

    //disabled for ANV
    //TODO : discuss with Virginie
    foreach ($params['tplParams']['activity']['customGroups'] as $cg) {
      foreach ($cg as $group => $value) {
        //assign the custom data to templates for this
        //message template
        $params['tplParams']['custom_'.$value['fieldID']] = $value['value'];
      }
    }
    }
  }
}
