# com.cividesk.pledgeletters

This extension adds a **Pledge Letters – print or email** task to the **Find Pledges** search screen.

It is a direct port of legacy D7+CiviCRM 5.x functionality into D10+CiviCRM 6.x.
The UI and workflow mirror the standard **Contributions → PDF Letters**, but adapted for pledges.

## Features

- Adds a new search action: **Pledge Letters – print or email**.
- Full **Print/Merge Document** UI (Use Template, Page Format, Preview, WYSIWYG editor).
- Pledge-specific options:
  - **From Email Address**
  - **Print and email options** (PDFs only, email, both; optional PDF attachment modes honored if site allows attachments).
  - **Update pledge thank-you dates** checkbox.
- Generates a single **combined PDF** for all selected contacts and/or sends individualized emails.
- Logs an **Activity** ("Print PDF Letter") per contact.
- Updates `thankyou_date` on the affected pledges when requested.
- Provides **custom pledge tokens** in the token picker and when merging:
  - `{pledge.id}`
  - `{pledge.pledge_amount}` (formatted)
  - `{pledge.pledge_total_paid}` (formatted; computed from pledge payments)
  - `{pledge.pledge_balance}` (formatted; amount minus total paid)
  - `{pledge.create_date}` (formatted; shows pledge start date)
  - `{pledge.pledge_next_pay_date}` (formatted; earliest pending payment date)
  - `{pledge.pledge_next_pay_amount}` (formatted; earliest pending scheduled amount)
  - `{pledge.pledge_financial_type}` (financial type name)

> Notes
>
> * The "total paid" and "next due" values are derived from **PledgePayment** rows.
> * During merge, pledge values are also exposed to Smarty as `{$pledge.*}` for legacy templates.

## Installation

1. Place the extension in your CiviCRM extensions directory, e.g.:

   ```
   web/sites/default/files/civicrm/ext/com.cividesk.pledgeletters
   ```

2. Clear caches:

   ```bash
   cv flush
   # (and drush cr if applicable)
   ```

3. Enable via **Administer → System Settings → Extensions**.

## Usage

1. Go to **Search → Find Pledges**.
2. Select one or more pledges (or open a pledge in single mode).
3. Choose **Pledge Letters – print or email** from the **Actions** menu.
4. Compose using the standard **Print/Merge** interface (choose a message template, tweak content, select format).
5. Click **Make Pledge Letters**.
6. Depending on your selections:

   - Emails are sent (with or without attached PDFs).
   - A combined PDF downloads/streams.
   - Activities are logged and (optionally) pledge `thankyou_date` is updated.

## Tokens

This extension registers pledge tokens for the editor’s token picker and for merging:

- `{pledge.id}`
- `{pledge.pledge_amount}`
- `{pledge.pledge_total_paid}`
- `{pledge.pledge_balance}`
- `{pledge.create_date}`
- `{pledge.pledge_next_pay_date}`
- `{pledge.pledge_next_pay_amount}`
- `{pledge.pledge_financial_type}`

Legacy Smarty access during merge:

```smarty
{$pledge.id}
{$pledge.amount}         
{$pledge.total_paid}     
{$pledge.balance}        
{$pledge.next_pay_date}  
{$pledge.next_pay_amount}
```

## How it works (technical)

- The task form reuses core’s **PDFLetterCommon** UI via `CRM_Contact_Form_Task_PDFTrait`.
- Pledges are loaded with API4; **derived** values (`total_paid`, `next_pay_*`) are computed from **PledgePayment** data.
- Token rendering uses the **TokenProcessor** (same pipeline as the preview UI), so previews and final output match.
- Emails use the selected "From Email Address"; optional PDF attachments are created in memory and attached when selected.
- Activities are created with type **"Print PDF Letter"**.

## Troubleshooting

- **"Because your session timed out, we have reset the search page."**
  This is a generic search controller message. Make sure you are launching the task from **Find Pledges** after selecting results, and that you haven’t let the tab idle. If in doubt, re-run the search and re-select.

## Development notes

- Primary class: `CRM/Pledgeletters/Form/Task/PDFLetter.php`
- Hooks: `pledgeletters.php`

  - Adds the search task
  - Registers tokens (`civicrm_tokens`)
  - Supplies token values (`civicrm_tokenValues`)
- Template for the task form: `templates/CRM/Pledgeletters/Form/Task/PDFLetter.tpl`
- After changes, **always** clear caches: `cv flush`.
