<?php
declare(strict_types = 1);

// phpcs:disable PSR1.Files.SideEffects
require_once 'unsubscribereason.civix.php';
// phpcs:enable

use CRM_Unsubscribereason_ExtensionUtil as E;

/**
 * Implements hook_civicrm_config().
 *
 * @link https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_config/
 */
function unsubscribereason_civicrm_config(\CRM_Core_Config $config): void {
  _unsubscribereason_civix_civicrm_config($config);
}

/**
 * Implements hook_civicrm_install().
 *
 * @link https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_install
 */
function unsubscribereason_civicrm_install(): void {
  _unsubscribereason_civix_civicrm_install();
}

/**
 * Implements hook_civicrm_enable().
 *
 * @link https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_enable
 */
function unsubscribereason_civicrm_enable(): void {
  _unsubscribereason_civix_civicrm_enable();
}

/**
 * Implementation of hook_civicrm_buildForm
 */
function unsubscribereason_civicrm_buildForm($formName, &$form) {
  if ($formName == 'CRM_Mailing_Form_Optout' || $formName == 'CRM_Mailing_Form_Unsubscribe') {
    $qid = CRM_Utils_Request::retrieve('qid', 'Integer', $form);
    list($displayName, $email, $contactId) = CRM_Mailing_Event_BAO_Queue::getContactInfo($qid);

    //get pre-configured profile ID and show the fields in the form
    $result = civicrm_api3('UFGroup', 'get', [
      'sequential' => 1,
      'return' => ['id'],
      'name' => 'Unsubscribe_reason_99',
    ]);

    $id = $result['id'];

    $name = 'mailingProfile';
    buildCustom($id, $contactId, $form, $name);
    $profileFields = CRM_Core_BAO_UFGroup::getFields($id, FALSE, CRM_Core_Action::ADD);

    CRM_Core_BAO_UFGroup::setProfileDefaults($contactId, $profileFields, $defaults, TRUE);
    $form->setDefaults(array('email_confirm' => $email));
    foreach($defaults as $key => $val) {
      $form->setDefaults(array($key => $val));
    }
  }
}

/**
 * Implementation of hook_civicrm_postProcess
 */
function unsubscribereason_civicrm_postProcess($formName, &$form) {
  if ($formName == 'CRM_Mailing_Form_Optout' || $formName == 'CRM_Mailing_Form_Unsubscribe') {
    $params = $form->_submitValues;
    //get pre-configured profile ID and save the unsubscribe reasons for the contact
    $result = civicrm_api3('UFGroup', 'get', [
      'sequential' => 1,
      'return' => ['id'],
      'name' => 'Unsubscribe_reason_99',
    ]);
    $id = $result['id'];
    $qid = CRM_Utils_Request::retrieve('qid', 'Integer', $form);

    $profileFields = CRM_Core_BAO_UFGroup::getFields($id, FALSE, CRM_Core_Action::ADD);
    list($displayName, $email, $contactId) = CRM_Mailing_Event_BAO_Queue::getContactInfo($qid);
    CRM_Contact_BAO_Contact::createProfileContact($params, $profileFields, $contactId);
  }
}

/**
   * Build the petition profile form.
   *
   * @param int $id
   * @param string $name
   * @param bool $viewOnly
 */
function buildCustom($id, $contactID, $form, $name, $viewOnly = FALSE) {
  if ($id) {
    $fields = NULL;
    // TODO: contactID is never set (commented above)
    if ($contactID) {
      if (CRM_Core_BAO_UFGroup::filterUFGroups($id, $contactID)) {
        $fields = CRM_Core_BAO_UFGroup::getFields($id, FALSE, CRM_Core_Action::ADD);
      }
    }
    else {
      $fields = CRM_Core_BAO_UFGroup::getFields($id, FALSE, CRM_Core_Action::ADD);
    }

    if ($fields) {
      $form->assign($name, $fields);

      foreach ($fields as $key => $field) {
        if ($viewOnly &&
           isset($field['data_type']) &&
          $field['data_type'] == 'File' || ($viewOnly && $field['name'] == 'image_URL')
        ) {
          // ignore file upload fields
          continue;
        }

        // if state or country in the profile, create map
        list($prefixName, $index) = CRM_Utils_System::explode('-', $key, 2);

        CRM_Core_BAO_UFGroup::buildProfile($form, $field, CRM_Profile_Form::MODE_CREATE, $contactID, TRUE);
        $form->_fields[$key] = $field;
      }
    }
  }
}